<?php
/*
    پنل مدیریت MadelineProto - نسخه 3.3 (نهایی)
    - کاملاً سازگار با آخرین نسخه MadelineProto (v8.x)
    - استفاده از PHP Session برای لاگین امن و پایدار (فقط یک بار لاگین می‌کنید)
    - رفع مشکل 404 در فرم لاگین با استفاده از action پویا
    - رفع کامل خطای "Call to undefined method getDialogs"
*/
ini_set('display_errors', 1);
error_reporting(E_ALL);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// !!!!!!!!!!! لطفاً یک رمز عبور پیچیده و جدید انتخاب کنید !!!!!!!!!!!
define('PANEL_PASSWORD', 'vcxsefbfrefvedcdsdsq'); // <<<< رمز عبور شما برای ورود به پنل
define('SESSIONS_DIR', __DIR__ . '/sessions/');

$error_message = '';
$is_logged_in = isset($_SESSION['madeline_panel_logged_in']) && $_SESSION['madeline_panel_logged_in'] === true;

// مدیریت لاگین
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === PANEL_PASSWORD) {
        $_SESSION['madeline_panel_logged_in'] = true;
        header("Location: " . $_SERVER['PHP_SELF']); // ریدایرکت برای جلوگیری از ارسال مجدد فرم
        exit;
    } else {
        $error_message = 'رمز عبور اشتباه است.';
    }
}

// مدیریت لاگ اوت
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

$selected_session = $_SESSION['selected_session'] ?? '';
$madeline_output = '';

// انتخاب سشن
if ($is_logged_in && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_session'])) {
    $selected_session = basename($_POST['selected_session']);
    if (!empty($selected_session) && file_exists(SESSIONS_DIR . $selected_session)) {
        $_SESSION['selected_session'] = $selected_session;
    } else {
        $_SESSION['selected_session'] = '';
        $selected_session = '';
    }
}

// اجرای دستورات
if ($is_logged_in && !empty($selected_session) && isset($_POST['command'])) {
    try {
        if (!file_exists('madeline.php')) {
            die('فایل madeline.php پیدا نشد!');
        }
        require_once 'madeline.php';

        $MadelineProto = new \danog\MadelineProto\API(SESSIONS_DIR . $selected_session);
        $MadelineProto->start();

        ob_start();

        switch ($_POST['command']) {
            case 'getSelf':
                echo "<h3>اطلاعات اکانت (getSelf):</h3>";
                print_r($MadelineProto->getSelf());
                break;
            case 'getDialogs':
                echo "<h3>۱۰ چت اخیر (getDialogs):</h3>";
                // ########## سینتکس صحیح و مدرن برای نسخه جدید ##########
                print_r($MadelineProto->getDialogs());
                break;
            case 'sendMessage':
                 if (!empty($_POST['peer']) && !empty($_POST['message'])) {
                    $peer = trim($_POST['peer']);
                    $message = trim($_POST['message']);
                    $MadelineProto->messages->sendMessage(peer: $peer, message: $message);
                    echo "<p style='color: #48BB78;'>پیام با موفقیت به " . htmlspecialchars($peer) . " ارسال شد.</p>";
                } else {
                    echo "<p style='color: #F56565;'>برای ارسال پیام، نام کاربری/ID و متن پیام الزامی است.</p>";
                }
                break;
        }
        $madeline_output = ob_get_clean();

    } catch (\Throwable $e) {
        $madeline_output = "<h3>خطای MadelineProto:</h3><pre>" . htmlspecialchars($e->getMessage()) . "\n\n" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>کنترل پنل MadelineProto - v3.3</title>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Vazirmatn', sans-serif; background-color: #1a202c; color: #e2e8f0; margin: 0; padding: 2rem; } .container { max-width: 900px; margin: auto; background-color: #2d3748; padding: 2rem; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); } h1, h2, h3 { color: #90cdf4; border-bottom: 1px solid #4a5568; padding-bottom: 0.5rem; } label { display: block; margin-top: 1rem; margin-bottom: 0.5rem; } input[type="text"], input[type="password"], select, textarea { width: 100%; padding: 0.75rem; background-color: #4a5568; border: 1px solid #718096; color: #e2e8f0; border-radius: 4px; box-sizing: border-box; } button { background-color: #3182ce; color: white; padding: 0.75rem 1.5rem; border: none; border-radius: 4px; cursor: pointer; font-size: 1rem; margin-top: 1rem; } button:hover { background-color: #2b6cb0; } a.logout { float: left; color: #f56565; text-decoration: none; margin-top: 10px; } .error { color: #f56565; background-color: #4c1d1d; border: 1px solid #f56565; padding: 1rem; border-radius: 4px; margin-bottom: 1rem; } .success { color: #9ae6b4; background-color: #2c523f; border: 1px solid #9ae6b4; padding: 1rem; border-radius: 4px; } .output { background-color: #1A202C; color: #cbd5e0; padding: 1rem; border-radius: 4px; margin-top: 1.5rem; white-space: pre-wrap; word-wrap: break-word; max-height: 500px; overflow-y: auto; text-align: left; direction: ltr; } .form-group { margin-bottom: 1.5rem; border: 1px solid #4a5568; padding: 1rem; border-radius: 5px; } </style>
</head>
<body>
    <div class="container">
        <h1><a href="?action=logout" class="logout"><?= $is_logged_in ? 'خروج' : '' ?></a>کنترل پنل MadelineProto</h1>
        <?php if (!$is_logged_in): ?>
            <h2>ورود به کنترل پنل</h2>
            <?php if ($error_message): ?><div class="error"><?= $error_message ?></div><?php endif; ?>
            <form method="POST" action="">
                <label for="password">رمز عبور:</label>
                <input type="password" id="password" name="password" required>
                <button type="submit">ورود</button>
            </form>
        <?php else: ?>
            <div class="form-group">
                <h2>انتخاب اکانت</h2>
                <form method="POST" action="">
                    <label for="session-select">فایل سشن:</label>
                    <select name="selected_session" id="session-select" onchange="this.form.submit()">
                        <option value="">-- یک سشن را انتخاب کنید --</option>
                        <?php
                        if (is_dir(SESSIONS_DIR)) {
                            $files = scandir(SESSIONS_DIR);
                            foreach ($files as $file) {
                                if (str_ends_with($file, '.madeline')) {
                                    $selected_attr = ($file === $selected_session) ? ' selected' : '';
                                    echo "<option value=\"".htmlspecialchars($file)."\"$selected_attr>".htmlspecialchars($file)."</option>";
                                }
                            }
                        }
                        ?>
                    </select>
                </form>
                 <?php if ($selected_session): ?>
                    <p class="success">اکانت <strong><?= htmlspecialchars($selected_session) ?></strong> با موفقیت انتخاب شد.</p>
                 <?php endif; ?>
            </div>
            <?php if ($selected_session): ?>
                <div class="form-group">
                    <h2>اجرای دستورات</h2>
                    <form method="POST" style="display: inline-block;" action=""><input type="hidden" name="command" value="getSelf"><button type="submit">اطلاعات اکانت (getSelf)</button></form>
                    <form method="POST" style="display: inline-block;" action=""><input type="hidden" name="command" value="getDialogs"><button type="submit">دریافت چت‌ها (getDialogs)</button></form>
                </div>
                <div class="form-group">
                    <h2>ارسال پیام</h2>
                    <form method="POST" action=""><input type="hidden" name="command" value="sendMessage"><label for="peer">آیدی عددی یا نام کاربری مقصد:</label><input type="text" id="peer" name="peer" placeholder="@username or chat_id" required><label for="message">متن پیام:</label><textarea id="message" name="message" rows="3" required></textarea><button type="submit">ارسال</button></form>
                </div>
            <?php endif; ?>
            <?php if ($madeline_output): ?><h3>خروجی دستور:</h3><div class="output"><?= $madeline_output ?></div><?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>

#### مرحله سوم: تست نهایی
1.  صفحه `penel.php` را در مرورگر باز کنید. برای اطمینان از پاک شدن کش، کلیدهای `Ctrl+Shift+R` را همزمان فشار دهید.
2.  با رمز عبور `vcxsefbfrefvedcdsdsq` وارد شوید.
3.  سشن خود را انتخاب کنید و دستورات را اجرا کنید.

با انجام این مراحل به ترتیب، هر دو مشکل شما به طور قطعی حل خواهد شد.